## R has a predefined dataset with the name "iris"
  # To know more about the dataset type "?iris" in the console

# 1) Creating Training and Testing data from "iris" dataset
  # 1.1) Generating Random Numbers
  set.seed(100)
  # 1.2) Creating sample for splitting dataset
  Sample <- sample(nrow(iris),0.7*nrow(iris))
  # 1.3) Training dataset containing 70% of data
  Training <- iris[Sample,]
  # 1.4) Testing dataset containing 30% of data
  Testing <- iris[-Sample,]
  
# 2) Normalizing data
  # 2.1) Normalizing training data
  Training[,1:4] <- scale(Training[,1:4])
  # 2.2) Normalizing testing data
  Testing[,1:4] <- scale(Testing[,1:4])
  
# 3) Labelling species
  # 3.1) Labelling species for training data
  Training$Species <- as.integer(factor(Training$Species))
  # 3.2) Labelling species for testing data
  Testing$Species <- as.integer(factor(Testing$Species))
  
# 4) Creating a Linear Regression model and predicting values
  # 4.1) Applying Linear Regression
  Model <- lm(Species~Sepal.Length+Sepal.Width+Petal.Length+Petal.Width,data = Training)
  # 4.2) Predicting species
  Prediction <- as.data.frame(predict(Model,Testing,interval = 'confidence'))
  
# 5) Plotting Predictions
  plot(Testing$Species,main = "Actual v/s Predicted Species",ylab = "",xlab = "",ylim = c(0.75,3.25))
  # 5.1) Adding a line to represent Upper Limit of prediction
  lines(Prediction$upr,lty = 1)
  # 5.2) Adding a line to represent Best Fit of prediction
  lines(Prediction$fit,lty = 2)
  # 5.3) Adding a line to represent Lower Limit of prediction
  lines(Prediction$lwr,lty = 3)
  # 5.4) Clipping legend to the figure region instead of the plot region
  par(xpd=TRUE)
  # 5.5) Adding a legend
  legend("topleft",text.width = 7,legend=c("Actual","Upper Limit","Predicted",
         "Lower Limit"),pch = c(1,NA,NA,NA) ,lty = c(NA,1,2,3) ,cex=0.8)
  # 5.6) Setting and adjusting labels of x and y axes
  title(ylab="Species",xlab="Index", line=2.25, cex.lab=1)
  
# 6) The Significance of resultant Linear Model
  summary.lm(Model)
  
# 7) Confidence Interval
  # 7.1) Printing Confidence Interval values
  print(Prediction$upr-Prediction$lwr)
  # 7.2) Plotting Confidence Interval
  plot(Prediction$upr-Prediction$lwr,main = "Confidence Interval",type = "b",ylab = "",xlab = "")
  # 7.3) Setting and adjusting labels of x and y axes
  title(ylab = "Interval",xlab="Index", line=2.25, cex.lab=1)